function getUid() {
    let now = new Date();
    let timestamp = now.getTime();
    let randomNumber = Math.ceil(Math.random() * 0xffffffff);
    return 'uid-'+timestamp.toString(16) + "-" + randomNumber.toString(16);
}

function showPopup(title, text, buttons = [], hasCloseBtn = true) {
    let html = `<div class="popup-container">
        <div class="popup">
            <button class="popup-close-btn">X</button>
            <h1 class="popup-title">Popup</h1>
            <p class="popup-text"></p>
            <div class="popup-buttons">
            </div>
        </div>
    </div>`;

    let popup = htmlToElement(html);
    let popupContent = popup.querySelector(".popup");
    let closeBtn = popup.querySelector(".popup-close-btn");
    let popupTitle = popup.querySelector(".popup-title");
    let popupText = popup.querySelector(".popup-text");
    let popupButtons = popup.querySelector(".popup-buttons");

    if (hasCloseBtn) {
        closeBtn.addEventListener("click", (e) => {
            e.preventDefault();
            popup.remove();
        });
    } else {
        closeBtn.remove();
    }

    popupTitle.textContent = title;
    popupText.textContent = text;

    let retButtons = {};
    for (let key in buttons) {
        let btn = buttons[key];
        let button = document.createElement("button");
        button.classList.add("button");
        retButtons[key] = button;
        if (typeof btn !== "object") {
            button.textContent = btn;
        } else {
            button.textContent = btn.text;
            if (btn.type) {
                button.classList.add(btn.type);
            }
        }
        popupButtons.appendChild(button);
    }

    popup.close = () => {
        popup.remove();
    };
    popup.buttons = retButtons;
    popup.popupContent = popupContent;

    document.body.appendChild(popup);

    return popup;
}

function showMsg(msg, openTime = 1000, type = "", target = null) {
    let currentMessages = document.querySelectorAll(".overlay-msg");
    for (let m of currentMessages) {
        m.classList.remove("open");
        setTimeout(() => {
            m.remove();
        },1000);
    }

    let msgEl = document.createElement('div');
    msgEl.classList.add('overlay-msg')
    msgEl.textContent = msg;

    if (type) {
        msgEl.classList.add(type);
    }

    if (!target) {
        target = document.body;
    }

    target.appendChild(msgEl);
    setTimeout(() => {
        msgEl.classList.add("open");
    }, 1);

    setTimeout(() => {
        msgEl.classList.remove("open");
        setTimeout(() => {
            msgEl.remove();
        },1000);
    }, openTime);
}

function startLoadingAnimation(target = null) {
    let loadingEl = document.createElement("div");
    loadingEl.classList.add("loading-overlay");
    let id = getUid();
    loadingEl.id = id; 
    if (!target) {
        target = document.body;
        loadingEl.style.position = 'fixed';
        loadingEl.style.height = '100vh';
    }


    if (!target?.style?.position) {
        target.style.position = "relative";
    }
    if(typeof(window.loadingAnimationStartRequired) !== 'object')
    {
        window.loadingAnimationStartRequired = {};
    }
    window.loadingAnimationStartRequired[id] = true;

    setTimeout(() => {
        if (window.loadingAnimationStartRequired[id]) {
            target.appendChild(loadingEl);
        }
    }, 200);

    return loadingEl.id;
}

function endLoadingAnimation(id) {
    if(!id) {
        let loadingAnimations = document.querySelectorAll('.loading-overlay');
        console.log(loadingAnimations);
        for(let el of loadingAnimations)
        {
            el.remove();
        }
        return true;
    }
    window.loadingAnimationStartRequired[id] = false;
    let loadingEl = document.getElementById(id);
    if (!loadingEl) {
        return false;
    }

    if (!loadingEl.classList.contains("loading-overlay")) {
        return false;
    }

    loadingEl.remove();
    return true;
}

function htmlToElement(html) {
    let el = document.createElement("div");
    el.innerHTML = html;
    // console.log(el.firstElementChild);
    return el.firstElementChild;
}